/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.system.model;

import com.tp_link.eap.domain.account.User;
import com.tp_link.eap.domain.site.Privilege;
import com.tp_link.eap.monitor.system.model.UserModel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class UserSiteModel
extends UserModel {
    private List<String> selectSiteList;

    public static UserSiteModel convertFromUser(User user, List<Privilege> userPrivileges) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return UserSiteModel.convertFromUser(user, simpleDateFormat, userPrivileges);
    }

    public static UserSiteModel convertFromUser(User user, SimpleDateFormat format, List<Privilege> userPrivileges) {
        if (user == null) {
            return null;
        }
        if (format == null) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        UserSiteModel userSiteModel = new UserSiteModel();
        userSiteModel.setUserId(user.getId());
        userSiteModel.setUserName(user.getName());
        userSiteModel.setEmail(user.getEmail());
        userSiteModel.setDescription(user.getDescription());
        userSiteModel.setCreatedTime(format.format(user.getCreatedTime()));
        userSiteModel.setSysDefault(user.isDefault());
        userSiteModel.setRoleId(user.getRole().getId());
        userSiteModel.setRoleName(user.getRole().getName());
        ArrayList<String> arrayList = new ArrayList<String>();
        if (userPrivileges != null) {
            for (Privilege privilege : userPrivileges) {
                arrayList.add(privilege.getSiteName());
            }
        }
        userSiteModel.setSelectSiteList(arrayList);
        return userSiteModel;
    }

    @Override
    public List<String> getSelectSiteList() {
        return this.selectSiteList;
    }

    @Override
    public void setSelectSiteList(List<String> selectSiteList) {
        this.selectSiteList = selectSiteList;
    }
}

